% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stri_replace_na}
\alias{stri_replace_na}
\title{Replace Missing Values in a Character Vector}
\usage{
stri_replace_na(str, replacement = "NA")
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{replacement}{single string}
}
\value{
Returns a character vector.
}
\description{
This function gives a convenient way to replace each missing (\code{NA})
value with a given string.
}
\details{
This function is roughly equivalent to
\code{str2 <- stri_enc_toutf8(str);
str2[is.na(str2)] <- stri_enc_toutf8(replacement);
str2}.
It may be used, e.g., wherever the 'plain R' \code{NA} handling is
desired, see Examples.
}
\examples{
x <- c('test', NA)
stri_paste(x, 1:2)                           # 'test1' NA
paste(x, 1:2)                                # 'test 1' 'NA 2'
stri_paste(stri_replace_na(x), 1:2, sep=' ') # 'test 1' 'NA 2'

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other utils: 
\code{\link{stri_list2matrix}()},
\code{\link{stri_na2empty}()},
\code{\link{stri_remove_empty}()}
}
\concept{utils}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
