# ROCm 6.2.4 release notes

The release notes provide a summary of notable changes since the previous ROCm release.

- [Release highlights](#release-highlights)

- [Operating system and hardware support changes](#operating-system-and-hardware-support-changes)

- [ROCm components versioning](#rocm-components)

- [Detailed component changes](#detailed-component-changes)

- [ROCm known issues](#rocm-known-issues)

- [ROCm upcoming changes](#rocm-upcoming-changes)

```{note}
If you’re using Radeon™ PRO or Radeon GPUs in a workstation setting with a
display connected, continue to use ROCm 6.2.3. See the [Use ROCm on Radeon
GPUs](https://rocm.docs.amd.com/projects/radeon/en/latest/index.html)
documentation to verify compatibility and system requirements.
```

## Release highlights

The following are notable new features and improvements in ROCm 6.2.4. For changes to individual components, see
[Detailed component changes](#detailed-component-changes).

#### ROCm documentation updates

ROCm documentation continues to be updated to provide clearer and more comprehensive guidance for
a wider variety of user needs and use cases.

* Added a new GPU cluster networking guide. See
  [Cluster network performance validation for AMD Instinct GPUs](https://rocm.docs.amd.com/projects/gpu-cluster-networking/en/latest/index.html).

  This documentation provides guidelines on validating network configurations
  in single-node and multi-node environments to attain optimal speed and bandwidth
  in AMD Instinct-powered clusters.

* Updated the HIP runtime documentation.

  * Added a new section on how to use [HIP graphs](https://rocm.docs.amd.com/projects/HIP/en/latest/how-to/hipgraph.html).

  * Added a new section about the [Stream ordered memory allocator (SOMA)](https://rocm.docs.amd.com/projects/HIP/en/latest/how-to/stream_ordered_allocator.html).

  * Updated the [Porting CUDA driver API](https://rocm.docs.amd.com/projects/HIP/en/latest/how-to/hip_porting_driver_api.html) section.

* Updated the [Post-installation instructions](https://rocm.docs.amd.com/projects/install-on-linux/en/docs-6.2.4/install/post-install.html)
  with guidance on using the `update-alternatives` utility and environment modules to help you manage multiple ROCm
  versions and streamline PATH configuration.

* Updated [LLM inference performance validation on AMD Instinct
  MI300X](https://rocm.docs.amd.com/en/docs-6.2.4/how-to/performance-validation/mi300x/vllm-benchmark.html)
  documentation with more detailed guidance, new models, and the `float8` data type.
