/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CHEWY_ANIDAT_H
#define CHEWY_ANIDAT_H

namespace Chewy {

#define SIB_CABLE_R1 1
#define SIB_MONOCLE 6
#define SIB_NOTEBOOK 7
#define SIB_TERMINAL_R5 8
#define SIB_BUTTON_R5 9
#define SIB_DOOR_R5 10
#define SIB_TBUTTON1_R6 11
#define SIB_SEIL 12
#define SIB_TBUTTON2_R6 13
#define SIB_TBUTTON3_R6 15
#define SIB_BOLA_SCHACHT 17
#define SIB_BOLA_BUTTON_R6 18
#define SIB_BOLA_FLECK_R6 20
#define SIB_BOLA_R6 21
#define SIB_TBUTTON1_R7 22
#define SIB_HEBEL_R7 23
#define SIB_KLINGEL_R7 24
#define SIB_GIPS_R7 25
#define SIB_TBUTTON2_R7 26
#define SIB_SCHLOTT_R7 27
#define SIB_LHAKEN_R7 28
#define SIB_RHAKEN_R7 29
#define SIB_FOLTER_R8 30
#define SIB_GTUER 31
#define SIB_TUER_R8 32
#define SIB_GIPS_R8 33
#define SIB_DEE_PAINT_R9 34
#define SIB_GGITTER_R9 35
#define SIB_SURIMY_R10 36
#define SIB_PAINT_R22 37
#define SIB_SCHLITZ_R11 38
#define SIB_TBUTTON1_R11 39
#define SIB_BANDBUTTON_R13 40
#define SIB_TBUTTON2_R11 41
#define SIB_TBUTTON3_R11 42
#define SIB_CARTRIDGE_R23 43
#define SIB_FLUXO_R23 44
#define SIB_TRANSLATOR_23 45
#define SIB_FEUER_R14 46
#define SIB_TALISMAN_R12 47
#define SIB_ROEHRE_R12 48
#define SIB_L_ROEHRE_R12 49
#define SIB_GITTER_R16 50
#define SIB_SCHALTER1_R21 51
#define SIB_SCHALTER2_R21 52
#define SIB_SCHALTER3_R21 53
#define SIB_SEIL_R21 54
#define SIB_GITTER1_R21 55
#define SIB_GITTER2_R21 56
#define SIB_FLUESSIG_R17 57
#define SIB_HEBEL_R17 58
#define SIB_CART1_R18 59
#define SIB_DOORKNOB_R18 60
#define SIB_CART_FACH_R18 61
#define SIB_SCHLAUCH_R25 62
#define SIB_SCHLAUCH_R26 63
#define SIB_TRICHTER_R26 64
#define SIB_ANGEL0_R26 65
#define SIB_MILCH_R27 66
#define SIB_AUTO_SITZ 67
#define SIB_PUTE_R34 68
#define SIB_KAFFEE_R33 69
#define SIB_ZAPPER_R39 70
#define SIB_KNOCHEN_R35 71
#define SIB_RADIO_R35 72
#define SIB_TOPF_R31 73
#define SIB_HFUTTER1_R37 74
#define SIB_HFUTTER2_R37 75
#define SIB_KUERBIS_R37 76
#define SIB_AUTO_R28 77
#define SIB_SURIMY_R27 78
#define SIB_ZEITUNG_R27 79
#define SIB_BKASTEN_R28 80
#define SIB_MUENZE_R40 81
#define SIB_VISIT_R53 82
#define SIB_CIGAR_R50 83
#define SIB_KAPPE_R51 84
#define SIB_FLASCHE_R51 85
#define SIB_LAMPE_R52 86
#define SIB_AUSRUEST_R51 87
#define SIB_KAUTABAK_R56 88
#define SIB_ASHTRAY_R64 89
#define SIB_PIRANHA 90
#define SIB_SCHALL 91
#define SIB_ARTEFAKT 92
#define SIB_AUSRUEST_R52 93

} // namespace Chewy

#endif
