/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright Openedhand Ltd.
 *
 * Author: Richard Purdie <richard@openedhand.com>
 *         Binbin Zhou <zhoubinbin@loongson.cn>
 *
 */

#ifndef _ES8323_H
#define _ES8323_H

/* ES8323 register space */

/* Chip Control and Power Management */
#define ES8323_CONTROL1		0x00
#define ES8323_CONTROL2		0x01
#define ES8323_CHIPPOWER	0x02
#define ES8323_ADCPOWER		0x03
#define ES8323_DACPOWER		0x04
#define ES8323_CHIPLOPOW1	0x05
#define ES8323_CHIPLOPOW2	0x06
#define ES8323_ANAVOLMANAG	0x07
#define ES8323_MASTERMODE	0x08

/* ADC Control */
#define ES8323_ADCCONTROL1	0x09
#define ES8323_ADCCONTROL2	0x0a
#define ES8323_ADCCONTROL3	0x0b
#define ES8323_ADCCONTROL4	0x0c
#define ES8323_ADCCONTROL5	0x0d
#define ES8323_ADCCONTROL6	0x0e
#define ES8323_ADC_MUTE		0x0f
#define ES8323_LADC_VOL		0x10
#define ES8323_RADC_VOL		0x11
#define ES8323_ADCCONTROL10	0x12
#define ES8323_ADCCONTROL11	0x13
#define ES8323_ADCCONTROL12	0x14
#define ES8323_ADCCONTROL13	0x15
#define ES8323_ADCCONTROL14	0x16

/* DAC Control */
#define ES8323_DACCONTROL1	0x17
#define ES8323_DACCONTROL2	0x18
#define ES8323_DAC_MUTE		0x19
#define ES8323_LDAC_VOL		0x1a
#define ES8323_RDAC_VOL		0x1b
#define ES8323_DACCONTROL6	0x1c
#define ES8323_DACCONTROL7	0x1d
#define ES8323_DACCONTROL8	0x1e
#define ES8323_DACCONTROL9	0x1f
#define ES8323_DACCONTROL10	0x20
#define ES8323_DACCONTROL11	0x21
#define ES8323_DACCONTROL12	0x22
#define ES8323_DACCONTROL13	0x23
#define ES8323_DACCONTROL14	0x24
#define ES8323_DACCONTROL15	0x25
#define ES8323_DACCONTROL16	0x26
#define ES8323_DACCONTROL17	0x27
#define ES8323_DACCONTROL18	0x28
#define ES8323_DACCONTROL19	0x29
#define ES8323_DACCONTROL20	0x2a
#define ES8323_DACCONTROL21	0x2b
#define ES8323_DACCONTROL22	0x2c
#define ES8323_DACCONTROL23	0x2d
#define ES8323_LOUT1_VOL	0x2e
#define ES8323_ROUT1_VOL	0x2f
#define ES8323_LOUT2_VOL	0x30
#define ES8323_ROUT2_VOL	0x31
#define ES8323_DACCONTROL28	0x32
#define ES8323_DACCONTROL29	0x33
#define ES8323_DACCONTROL30	0x34

#define ES8323_ADC_IFACE	ES8323_ADCCONTROL4
#define ES8323_ADC_SRATE	ES8323_ADCCONTROL5
#define ES8323_DAC_IFACE	ES8323_DACCONTROL1
#define ES8323_DAC_SRATE	ES8323_DACCONTROL2
#endif
