from __future__ import annotations

import os
import re

PYPI_WEB_DOMAIN = "pypi.org"

# https://semver.org/#is-there-a-suggested-regular-expression-regex-to-check-a-semver-string
SEMVER_REGEX = re.compile(
    r"""
    (?P<major>0|[1-9]\d*)
    \.
    (?P<minor>0|[1-9]\d*)
    \.
    (?P<patch>0|[1-9]\d*)
    (?:-(?P<prerelease>(?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\.(?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?
    (?:\+(?P<buildmetadata>[0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)*))?
    """,
    flags=re.VERBOSE,
)

COMMIT_MESSAGE = "{version}\n\nAutomatically generated by python-semantic-release"
DEFAULT_COMMIT_AUTHOR = "semantic-release <semantic-release>"
DEFAULT_VERSION = "0.0.0"

DEFAULT_SHELL: str | None = None
if os.name == "posix":
    DEFAULT_SHELL = os.getenv("SHELL", "/bin/sh")
elif os.name == "nt":
    DEFAULT_SHELL = os.getenv("COMSPEC")
