% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscape.R
\name{RunMixscape}
\alias{RunMixscape}
\title{Run Mixscape}
\usage{
RunMixscape(
  object,
  assay = "PRTB",
  slot = "scale.data",
  labels = "gene",
  nt.class.name = "NT",
  new.class.name = "mixscape_class",
  min.de.genes = 5,
  min.cells = 5,
  de.assay = "RNA",
  logfc.threshold = 0.25,
  iter.num = 10,
  verbose = FALSE,
  split.by = NULL,
  fine.mode = FALSE,
  fine.mode.labels = "guide_ID",
  prtb.type = "KO"
)
}
\arguments{
\item{object}{An object of class Seurat.}

\item{assay}{Assay to use for mixscape classification.}

\item{slot}{Assay data slot to use.}

\item{labels}{metadata column with target gene labels.}

\item{nt.class.name}{Classification name of non-targeting gRNA cells.}

\item{new.class.name}{Name of mixscape classification to be stored in
metadata.}

\item{min.de.genes}{Required number of genes that are differentially
expressed for method to separate perturbed and non-perturbed cells.}

\item{min.cells}{Minimum number of cells in target gene class. If fewer than
this many cells are assigned to a target gene class during classification,
all are assigned NP.}

\item{de.assay}{Assay to use when performing differential expression analysis.
Usually RNA.}

\item{logfc.threshold}{Limit testing to genes which show, on average,
at least X-fold difference (log-scale) between the two groups of cells.
Default is 0.25 Increasing logfc.threshold speeds up the function, but can miss
weaker signals.}

\item{iter.num}{Number of normalmixEM iterations to run if convergence does
not occur.}

\item{verbose}{Display messages}

\item{split.by}{metadata column with experimental condition/cell type
classification information. This is meant to be used to account for cases a
perturbation is condition/cell type -specific.}

\item{fine.mode}{When this is equal to TRUE, DE genes for each target gene
class will be calculated for each gRNA separately and pooled into one DE list
for calculating the perturbation score of every cell and their subsequent
classification.}

\item{fine.mode.labels}{metadata column with gRNA ID labels.}

\item{prtb.type}{specify type of CRISPR perturbation expected for labeling mixscape classifications. Default is KO.}
}
\value{
Returns Seurat object with with the following information in the
meta data and tools slots:
\describe{
  \item{mixscape_class}{Classification result with cells being either
  classified as perturbed (KO, by default) or non-perturbed (NP) based on their target
  gene class.}
  \item{mixscape_class.global}{Global classification result (perturbed, NP or NT)}
  \item{p_ko}{Posterior probabilities used to determine if a cell is KO (default). Name of this item will change to match prtb.type parameter setting.
  (>0.5) or NP}
  \item{perturbation score}{Perturbation scores for every cell calculated in
  the first iteration of the function.}
}
}
\description{
Function to identify perturbed and non-perturbed gRNA expressing cells that
accounts for multiple treatments/conditions/chemical perturbations.
}
\concept{mixscape}
